import des_database
from flask import Flask, redirect, url_for, request, render_template

app = Flask(__name__)

des_di = {"감기":1, "눈병":2, "천식":3, "피부염":4}

@app.route('/', methods=['GET'])  # methods = ['GET', 'POST']) 로 여러 개 가능
def login():
    return render_template('login.html')


@app.route('/submit', methods=['POST'])
def submit():
    if request.method == 'POST':
        city = request.form['city']
        date = request.form['date']
        date_fix = date.replace("-", "")
        des = request.form['des']
        dis = des_di[des]

        cities,num = des_database.select_DB(city,date_fix,dis)
        cities.append([city,num])
        print(cities)

        return render_template('des.html',cities = cities, city = city, date = date_fix, des = des)


if __name__ == '__main__':
    app.run(host="127.0.0.1", port="8080")
